; Inno Setup Script for FLUX-TUI Professional
; This script generates a professional Windows Installer (.exe)

[Setup]
AppName=FLUX-TUI
AppVersion=1.7.0
DefaultDirName={autopf}\FLUX-TUI
DefaultGroupName=FLUX-TUI
UninstallDisplayIcon={app}\flux-tui-windows.exe
Compression=lzma2
SolidCompression=yes
OutputDir=dist\installer
OutputBaseFilename=flux-tui-setup
SetupIconFile=ico.ico
PrivilegesRequired=lowest
WizardStyle=modern

[Languages]
Name: "english"; MessagesFile: "compiler:Default.isl"

[Tasks]
Name: "desktopicon"; Description: "{cm:CreateDesktopIcon}"; GroupDescription: "{cm:AdditionalIcons}"; Flags: unchecked

[Files]
Source: "dist\flux-tui-windows.exe"; DestDir: "{app}"; Flags: ignoreversion
Source: "ico.ico"; DestDir: "{app}"; Flags: ignoreversion

[Icons]
Name: "{group}\FLUX-TUI"; Filename: "{app}\flux-tui-windows.exe"; IconFilename: "{app}\ico.ico"
Name: "{autodesktop}\FLUX-TUI"; Filename: "{app}\flux-tui-windows.exe"; IconFilename: "{app}\ico.ico"; Tasks: desktopicon

[Run]
Filename: "{app}\flux-tui-windows.exe"; Description: "{cm:LaunchProgram,FLUX-TUI}"; Flags: nowait postinstall skipifsilent
