# FLUX-TUI: Professional Offline File Encryption Vault

**FLUX-TUI** is a high-grade, fully offline file encryption vault designed for professional security. It features an interactive command-line terminal interface (TUI) to protect sensitive data using authenticated AES-256-GCM encryption.

---

## 🛡️ Core Security Features

- **AES-256-GCM Encryption**: Securely encrypt and decrypt files using industry-standard authenticated encryption.
- **Master Security Key**: Robust login system using PBKDF2 with SHA-256 hashing and random salts.
- **Enhanced Professional TUI**: Sleek dashboard with purple accents, real-time status, and progress indicators.
- **Theme Customization**: Seamless switching between Dark and Light visual modes.
- **Drag & Drop Integration**: Encrypt or decrypt files by simply dragging them into the terminal.
- **Vault Management**: Automated organization of encrypted files in a secure local directory.
- **Zero External Dependencies**: Works entirely offline with no internet connection or accounts required.

---

## 🚀 Quick Start (Native Windows Build)

This project is optimized for **Native Windows** builds using **Python 3.13**.

### 1. Build Your Windows .exe
To generate a standalone executable for your Windows laptop:

1.  **Open terminal** in the project directory in VS Code.
2.  **Run the build command**:
    ```bash
    python build_app.py
    ```
    *Note: The script will automatically install all required libraries (PyInstaller, Rich, Cryptography) for you. It uses a path-independent execution method to ensure success.*
3.  **Check artifacts**: The final executable (`flux-tui-windows.exe`) will appear in the `dist/` folder.

### 2. Run the Application
Once you have the `flux-tui-windows.exe` in your `dist/` folder, simply double-click it to start the vault system.

---

## 🛠️ Command Reference

| Command | Description |
| :--- | :--- |
| `encrypt` | Securely encrypt a file and move it to the vault (supports Drag & Drop). |
| `decrypt` | Restore an encrypted file from the vault (supports Drag & Drop). |
| `vault` | List all encrypted files currently stored in your secure vault. |
| `delete` | Permanently remove a specific file from the vault. |
| `export` | Decrypt a file and save it to a specific external location. |
| `theme` | Toggle between Dark and Light visual modes. |
| `changepassword` | Update your master security key for the entire vault. |
| `help` | Refresh the dashboard and show the list of available commands. |
| `exit` | Securely close the application session. |

---

## 📦 Professional Build System (Path-Independent v14)

**FLUX-TUI** uses a specialized native build system to ensure 100% reliability on Windows.

- **Direct Execution**: It uses `python -m PyInstaller` to ensure build tools are executed correctly, even if your Windows PATH is not configured.
- **Automated Dependency Management**: The build script automatically installs all required libraries (`rich`, `cryptography`, `pyinstaller`) using your local Python 3.13 environment.
- **High-Performance Packaging**: PyInstaller creates a single standalone executable that includes all your code, the source files, and the application icon.

---

## 📁 Project Architecture

- `main.py`: Professional application entry point with error handling.
- `build_app.py`: Optimized native Windows build script.
- `src/`:
  - `auth.py`: PBKDF2/SHA-256 security key authentication.
  - `crypto.py`: AES-256-GCM encryption and decryption engine.
  - `vault.py`: Automated vault directory management.
  - `settings.py`: Persistent configuration and theme engine.
  - `ui.py`: High-fidelity TUI layout and styling with Rich.
  - `cli.py`: Interactive command processor and user experience.
- `ico.ico`: High-resolution application icon.
- `requirements.txt`: Project dependencies list.

---

## ⚠️ Security Notice

**FLUX-TUI** operates entirely on your local machine. Your master security key is never stored in plain text. Please ensure you remember your security key, as there is no recovery mechanism for encrypted files if the key is lost.
